/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.View;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class SplittedView
implements View {
    protected View fView1;
    protected View fView2;
    protected JSplitPane fSplitPane;

    public SplittedView() {
    }

    public SplittedView(View view) {
        this.fView1 = view;
        this.fView2 = (View)view.clone();
        this.fSplitPane = new JSplitPane(0, this.fView1.getViewComponent(), this.fView2.getViewComponent());
    }

    public SplittedView(View view, int orientation) {
        this.fView1 = view;
        this.fView2 = (View)view.clone();
        this.fSplitPane = new JSplitPane(orientation, this.fView1.getViewComponent(), this.fView2.getViewComponent());
        this.fSplitPane.setMinimumSize(this.fView1.getViewComponent().getSize());
    }

    public void centerDivider() {
        this.fSplitPane.setDividerLocation(0.5);
    }

    public Object clone() {
        return this.fView1.clone();
    }

    public SplittedView findViewContainer(View view) {
        SplittedView viewContainer = null;
        if (this.fView1 == view || this.fView2 == view) {
            return this;
        }
        if (this.fView1 instanceof SplittedView && (viewContainer = ((SplittedView)this.fView1).findViewContainer(view)) != null) {
            return viewContainer;
        }
        if (this.fView2 instanceof SplittedView && (viewContainer = ((SplittedView)this.fView2).findViewContainer(view)) != null) {
            return viewContainer;
        }
        return null;
    }

    public Editor getEditor() {
        return this.fView1.getEditor();
    }

    public Model getModel() {
        return this.fView1.getModel();
    }

    public View getView1() {
        return this.fView1;
    }

    public View getView2() {
        return this.fView2;
    }

    public JComponent getViewComponent() {
        return this.fSplitPane;
    }

    public boolean replaceView(View oldView, View newView) {
        boolean rw = false;
        if (this.fView1 == oldView) {
            this.fView1 = newView;
            rw = true;
        }
        if (this.fView2 == oldView) {
            this.fView2 = newView;
            rw = true;
        }
        return rw;
    }

    public void setOrientation(int orientation) {
        this.fSplitPane.setOrientation(orientation);
    }

    public void setView1(View newView1) {
        this.fView1 = newView1;
    }

    public void setView2(View newView2) {
        this.fView2 = newView2;
    }

    public void setModel(Model model) {
        this.fView1.setModel(model);
        this.fView2.setModel(model);
    }
}

